/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.Function;
import intrinsic.flash.display.DisplayObjectContainer;
import intrinsic.mx.collections.ArrayCollection;
import intrinsic.mx.containers.BoxDirection;
import intrinsic.mx.controls.ButtonBar;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;

public class ToolBar extends Composite {
	ArrayCollection items;

public ToolBar (Composite parent, int style) {
	super (parent, checkStyle (style));
	/*
	* Ensure that either of HORIZONTAL or VERTICAL is set.
	* NOTE: HORIZONTAL and VERTICAL have the same values
	* as H_SCROLL and V_SCROLL so it is necessary to first
	* clear these bits to avoid scroll bars and then reset
	* the bits using the original style supplied by the
	* programmer.
	*/
	if ((style & SWT.VERTICAL) != 0) {
		this.style |= SWT.VERTICAL;
	} else {
		this.style |= SWT.HORIZONTAL;
	}
	String orientation = (style & SWT.VERTICAL) != 0 ? BoxDirection.VERTICAL : BoxDirection.HORIZONTAL;
	((ButtonBar)object).direction = orientation;
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

public Point computeSize (int wHint, int hHint, boolean changed) {
	checkWidget ();
	return computeNativeSize (object, wHint, hHint, changed);
}

void createHandle () {
	ButtonBar widget = new ButtonBar ();
	widget.dataProvider = items = new ArrayCollection();
	widget.labelFunction = getLabelFunction();
	widget.iconField = "_image";
	object = widget;
}

void createItem (ToolItem item, int index) {
	if (!(0 <= index && index <= items.length)) error (SWT.ERROR_INVALID_RANGE);
	items.addItemAt(item, index);
}

static int checkStyle (int style) {
	/*
	* Feature in FLEX.  It is not possible to create
	* a toolbar that wraps.  Therefore, no matter what 
	* style bits are specified,	clear the WRAP bits so 
	* that the style matches the behavior.
	*/
	if ((style & SWT.WRAP) != 0) style &= ~SWT.WRAP;
	/*
	* Even though it is legal to create this widget
	* with scroll bars, they serve no useful purpose
	* because they do not automatically scroll the
	* widget's client area.  The fix is to clear
	* the SWT style.
	*/
	return style & ~(SWT.H_SCROLL | SWT.V_SCROLL);
}

Image _getImage(DisplayObjectContainer item) {
	return ((ToolItem)items.getItemAt(item.parent.getChildIndex(item))).image;
}

public ToolItem getItem (int index) {
	checkWidget ();
	if (!(0 <= index && index < items.length)) error (SWT.ERROR_INVALID_RANGE);
	return (ToolItem)items.getItemAt(index);
}

public ToolItem getItem (Point point) {
	checkWidget();
	return null;
}

public int getItemCount () {
	checkWidget();
	return items.length;
}

public ToolItem[] getItems () {
	checkWidget ();
	ToolItem[] result = new ToolItem[items.length];
	for (int i = 0; i < result.length; i++) {
		result[i] = (ToolItem)items.getItemAt(i);
	}
	return result;
}

String labelFunction (ToolItem item)  {
	return item.getText ();
}

native Function getLabelFunction () /*{
	return labelFunction__Lorg_eclipse_swt_widgets_ToolItem_2;
}*/;

public int getRowCount () {
	checkWidget ();
	return 1;
}

public int indexOf (ToolItem item) {
	checkWidget();
	return items.getItemIndex(item);
}

}
